# バッチ設計書 17-ci.yml - e2e job

## 概要

本ドキュメントは、three.jsプロジェクトにおけるGitHub Actions CIワークフローの「e2e」ジョブの設計仕様を定義する。

### 本バッチの処理概要

GitHub Actionsで実行されるCIワークフローのe2eジョブであり、E2Eテスト（スクリーンショット比較テスト）を5並列で実行する統合テストジョブである。マトリックス戦略により5つのジョブインスタンスが同時に起動し、examplesを分担して並列テストを行う。

**業務上の目的・背景**：three.jsプロジェクトには数百のexamplesが存在し、すべてを順次テストすると30分以上かかる。5並列で実行することで、総実行時間を大幅に短縮し、PRのフィードバックサイクルを改善する。各ジョブはCI環境変数（0〜4）を持ち、これによりexamplesを均等に分割して担当する。

**バッチの実行タイミング**：PRイベントでトリガー（build/、docs/、files/ディレクトリの変更は除外）。

**主要な処理内容**：
1. リポジトリのチェックアウト
2. Node.js 24環境のセットアップ
3. npm依存関係のインストール（npm ci）
4. モジュールビルドの実行（npm run build-module）
5. E2Eテストの実行（npm run test-e2e）
6. 失敗時のスクリーンショットアップロード

**前後の処理との関連**：testジョブと並列実行される。このジョブの成功はPRマージの推奨条件。

**影響範囲**：examples/配下の全HTMLサンプル、examples/screenshots/配下の参照画像。

## バッチ種別

CI/CD / E2Eテスト / GitHub Actions ジョブ / 並列処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | PRごと |
| 実行時刻 | PR作成・更新時 |
| 実行曜日 | 不定 |
| 実行日 | 不定 |
| トリガー | pull_request イベント |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHub Actions | GitHub Actionsが有効であること |
| ubuntu-latest | ubuntu-latestランナーが使用可能であること |
| Node.js 24 | Node.js 24がインストール可能であること |

### 実行可否判定

- paths-ignore: build/**, docs/**, files/** に該当しない変更であること
- PRが作成または更新されていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| matrix.CI | 数値 | Yes（自動） | 0,1,2,3,4 | 並列ジョブのインデックス |
| matrix.os | 文字列 | Yes（自動） | ubuntu-latest | 実行環境 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| リポジトリ全体 | Git | actions/checkout@v6によるチェックアウト |
| package.json | JSONファイル | npm scripts定義 |
| package-lock.json | JSONファイル | npm ci用の依存関係ロックファイル |
| examples/*.html | HTMLファイル | テスト対象のサンプルページ |
| examples/screenshots/*.jpg | JPEGファイル | 参照スクリーンショット |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub Actions ログ | テキスト | 各ステップの実行結果 |
| PR Status Check | ステータス | ジョブの成功/失敗状態 |
| Artifact | ZIPファイル | 失敗時の差分スクリーンショット |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Output screenshots-{os}-{CI番号} |
| 出力先 | GitHub Actions Artifacts |
| 内容 | test/e2e/output-screenshots/配下の差分画像 |
| 保存条件 | テスト失敗時のみ（if-no-files-found: ignore） |

## 処理フロー

### 処理シーケンス

```
1. Git checkout
   └─ actions/checkout@v6でリポジトリをチェックアウト

2. Install Node
   └─ actions/setup-node@v6でNode.js 24をセットアップ
   └─ npmキャッシュを有効化

3. Install dependencies
   └─ npm ciで依存関係をインストール

4. Build
   └─ npm run build-moduleでモジュールをビルド

5. E2E testing
   └─ npm run test-e2eでE2Eテストを実行
   └─ CI環境変数により担当examplesを決定

6. Upload output screenshots
   └─ 失敗時に差分画像をArtifactとしてアップロード
```

### フローチャート

```mermaid
flowchart TD
    A[PR作成/更新] --> B{paths-ignore<br>該当?}
    B -->|Yes| C[ジョブスキップ]
    B -->|No| D[e2eジョブ開始<br>5並列]
    D --> E1[CI=0]
    D --> E2[CI=1]
    D --> E3[CI=2]
    D --> E4[CI=3]
    D --> E5[CI=4]
    E1 --> F[Git checkout]
    E2 --> F
    E3 --> F
    E4 --> F
    E5 --> F
    F --> G[Node.js 24セットアップ]
    G --> H[npm ci]
    H --> I[npm run build-module]
    I --> J[npm run test-e2e<br>CI番号で分割実行]
    J --> K{テスト成功?}
    K -->|Yes| L[ジョブ成功]
    K -->|No| M[差分画像をArtifactにアップロード]
    M --> N[ジョブ失敗]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | スクリーンショット差分 | レンダリング結果が参照と異なる | コード修正またはスクリーンショット更新 |
| - | 参照画像なし | 新規exampleの参照画像がない | npm run make-screenshotで生成 |
| - | タイムアウト | 30分を超過 | 例外リストに追加検討 |
| - | ビルドエラー | build-moduleが失敗 | コードを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（ジョブレベル） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. GitHub ActionsのUIでエラーログを確認
2. Artifactから差分画像をダウンロードして確認
3. コード修正または`npm run make-screenshot`で参照画像を更新

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約60-80 examples/ジョブ（5分割） |
| 目標処理時間 | 30分以内（timeout-minutes: 30） |
| 並列度 | 5ジョブ |

## 排他制御

- fail-fast: false により、1ジョブの失敗が他ジョブをキャンセルしない
- 同一PRの複数コミットは最新のみ実行（GitHub Actionsのデフォルト）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ステップ開始 | 各ステップ開始時 | ステップ名 |
| E2Eテスト進捗 | 各example完了時 | Diff結果 |
| ステップ完了 | 各ステップ完了時 | 実行時間、成功/失敗 |
| Artifact | ジョブ完了時 | アップロードされたファイル情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ジョブ結果 | 失敗時 | PR Status Check、メール通知（設定による） |
| 処理時間 | 30分超過時 | GitHub Actionsタイムアウト |

## 備考

- ジョブ名: "E2E testing"
- マトリックス戦略: os=[ubuntu-latest], CI=[0,1,2,3,4]
- timeout-minutes: 30
- fail-fast: false（1ジョブの失敗で他を止めない）
- CI環境変数はtest/e2e/puppeteer.jsで読み取られ、examplesを5分割
- Artifact名: "Output screenshots-{os}-{CI番号}"
- if-no-files-found: ignoreにより、成功時はArtifactをアップロードしない
- actions/upload-artifact@v6を使用
